//////////////////////////////////////
//                                  //
//          windowsmedia.js         // 
//                                  //
//////////////////////////////////////
//
//               INSTRUCTIONS
//
// Use this file in your HTML documents by 
// including it in the head section
// of your document:
//
//   <script src="windowsmedia.js"></script>
//
// Then you can make calls to the functions
// described below to manipulate and query
// any named instance of a Windows Media
// audio or video embed.
//
// For example, if you have a Windows Media embed
// called "AudioClip", you can change its
// source with the WM_setSource() method:
//
//   WM_setSource("AudioClip","audio/a1t2p3b.rpm");
//
// You could then play the clip with the 
// WM_play() method:
//
//   WM_play("AudioClip");
//
// It is also possible to have multiple embeds
// that have unique names, and you can manage
// all of them with the G2 functions - just
// specify the embed name when making the
// function call.
//
// You will also notice that each function
// takes an optional document object as its
// last parameter.  This gives you the ability
// to control Windows Media embeds in a different
// frame, or even a different window all together.
// All you have to do is build a reference to
// the document which contains the embed bearing
// the name supplied in the function call.
// For example, if there was an embed named "VideoClip"
// in a frame called "VideoFrame" which resides in
// the same frameset as the current document, you could
// stop it, change it's source, then play it
// with the following calls:
//
//   WM_stop("VideoClip",parent.VideoFrame);
//   WM_setSource("VideoClip","video/v1t2p3b.rpm",parent.VideoFrame);
//   WM_play("VideoClip",parent.VideoFrame);
//
///////////////////////////////////////////////////////
//                                                   //
//        JavaScript Windows Media Functions         // 
//                                                   //
///////////////////////////////////////////////////////
// object WM_getClipRef(clipName[, doc])             //
// int WM_getPlayState(clipName[, doc])              //
// int WM_getPosition(clipName[, doc])               //
// void WM_setPosition(clipName, pos[, doc])         //
// void WM_setSource(clipName, sourceString[,  doc]) //
// void WM_setSourcePlay(clipName, sourceString[, doc])//	
// string WM_getSource(clipName[, doc])              //
// int WM_getLength(clipName[, doc])                 //
// void WM_stop(clipName[, doc])                     //
// void WM_play(clipName[, doc])                     //
// void WM_pause(clipName[, doc])                    //
// void WM_setVolume(clipName, vol[, doc])           //
// int WM_getVolume(clipName[, doc])                 //
///////////////////////////////////////////////////////
//                                              //
//      Windows Media Play State Constants      //
//////////////////////////////////////////////////
	var WM_STOPPED    = 0;
	var WM_PLAYING    = 2;
	var WM_PAUSED     = 1;
	var WM_WAITING    = 3;

	var WM_debug = true;
	
	var WM_recCount = 0;

	function WM_checkClipRef(clipRef, functionName, doc)
	{
		if (WM_checkClipRef.arguments.length < 3)
		{
			doc = document;
		}
	
		if ( typeof(clipRef) == 'string' )
		{
			return WM_getClipRef(clipRef, doc);
		}
		else
		{
			if ( typeof(clipRef) != 'object')
			{
				if (WM_debug)
					alert("Invalid argument to WM_checkClipRef():\n"+functionName+" clipRef needs to be a string or a clip reference.");
				return null;
			}
		}
		return clipRef;
	}
	
	function WM_getClipRef(clipName, doc)
	{
		WM_recCount = 0;
		if (WM_getClipRef.arguments.length < 2)
		{
			doc = document;
		}
		
		return WM_getClipRef2(clipName, doc);
	}

	function WM_getClipRef2(clipName, doc)
	{
		var clipRef = null;	
		
		// Base Case 1
		if (navigator.appName == "Microsoft Internet Explorer") 
		{
			clipRef = eval("doc." + clipName);
			return clipRef;
		}

		// Base Case 2
		if (WM_recCount++ >= 100) 
		{
			return null;
		}

		// Base Case 3
		if (doc.embeds.length > 0) // look for embed in the document	
		{
			if (doc.embeds[clipName] != null) 
			{
				clipRef = doc.embeds[clipName];
				return clipRef;
			}			
		}	

		// Possible Recursion	
		for (var i=0;i<doc.layers.length;i++) // for each layer in the document
		{
			//alert("You have found layer: " + doc.layers[i].id);
			if (doc.layers[i].document.embeds.length > 0)
			{
				if (doc.layers[i].document.embeds[clipName] != null) 
				{
					clipRef = doc.layers[i].document.embeds[clipName];
					return clipRef;
				}
			}
			if (doc.layers[i].document.layers.length > 0) 
				if ( (clipRef = WM_getClipRef2(clipName,doc.layers[i].document)) != null ) 
					break;
		}
		
		return clipRef;
	}

	
	function WM_getPlayState(clipName, doc)	
	{
		if (WM_getPlayState.arguments.length < 2)
		{
			doc = document;
		}		

		var clipRef = WM_checkClipRef(clipName,"WM_getPlayState",doc);		

		if (clipRef == null)
		{
			if (WM_debug)
				alert("In call to WM_getPlayState():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return WM_STOPPED;
		}
		else
		{
			return clipRef.PlayState;
		}
	}

	function WM_getPosition(clipName, doc)	
	{	
		if (WM_getPosition.arguments.length < 2)
		{
			doc = document;
		}		

		var clipRef = WM_checkClipRef(clipName,"WM_getPosition",doc);		

		if (clipRef == null)
		{
			if (WM_debug)
				alert("In call to WM_getPosition():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return 0;
		}
		else
		{
			return Math.round(clipRef.CurrentPosition*1000);
		}
	}

	function WM_setPosition(clipName, pos, doc)	
	{	
		if (WM_setPosition.arguments.length < 3)
		{
			doc = document;
		}		

		var clipRef = WM_checkClipRef(clipName,"WM_setPosition",doc);		

		if (clipRef == null)
		{
			if (WM_debug)
				alert("In call to WM_setPosition():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return;
		}
		else
		{
			return clipRef.CurrentPosition = (pos/1000);
		}
	}

	function WM_setSourcePlay(clipName, sourceString, doc)	
	{
		if (WM_setSourcePlay.arguments.length < 3)
		{
			doc = document;
		}		
		var clipRef = WM_checkClipRef(clipName,"WM_setSourcePlay",doc);		

		if (clipRef == null)
		{
			if (WM_debug)
				alert("In call to WM_setSourcePlay():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return;
		}
		else
		{
			//clipRef.AutoStart = true;
			clipRef.FileName = sourceString;
			WM_requestPlay(clipRef);
		}
	}
	
	var WM_playTimerId = null;
	var WM_playClipRef = null;
	
	function WM_requestPlay(clipRef)
	{
		WM_playClipRef = clipRef;
		clipRef.AutoStart = true;
		if (WM_playTimerId != null) clearInterval(WM_playTimerId);
		WM_playTimerId = setInterval("WM_tryPlay()",100);
	}
	
	function WM_tryPlay()
	{
		if (WM_playClipRef.ReadyState > 2)
		{
			clearInterval(WM_playTimerId);
			WM_playTimerId = null;
			WM_playClipRef.Play();
			WM_playClipRef = null;
		}
	}

	function WM_setSource(clipName, sourceString, doc)	
	{
		if (WM_setSource.arguments.length < 3)
		{
			doc = document;
		}		

		var clipRef = WM_checkClipRef(clipName,"WM_setSource",doc);		

		if (clipRef == null)
		{
			if (WM_debug)
				alert("In call to WM_setSource():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return;
		}
		else
		{
			clipRef.FileName = sourceString;
		}
	}

	function WM_getSource(clipName, doc)	
	{
		if (WM_getSource.arguments.length < 2)
		{
			doc = document;
		}		

		var clipRef = WM_checkClipRef(clipName,"WM_getSource",doc);		

		if (clipRef == null)
		{
			if (WM_debug)
				alert("In call to WM_getSource():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return null;
		}
		else
		{
			return WM_cleanupURL(clipRef.FileName);
		}
	}

	function WM_getLength(clipName, doc)	
	{	
		if (WM_getLength.arguments.length < 2)
		{
			doc = document;
		}		

		var clipRef = WM_checkClipRef(clipName,"WM_getLength",doc);		

		if (clipRef == null)
		{
			if (WM_debug)
				alert("In call to WM_getLength():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return null;
		}
		else
		{
			return clipRef.currentMedia.duration;
		}
	}

	function WM_cleanupURL(url)
	{
		url = url + "";
		for (var i=0;i<url.length;i++)
		{
			if (url.charCodeAt(i) < 32 || url.charCodeAt(i) > 126)
			{
				//alert("Illegal Character Found at position " + i);
				url = url.slice(0,i) + url.slice(i+1,url.length);
			} 
			else if (url.charAt(i) == "\\")
			{
				url = url.slice(0,i) + "/" + url.slice(i+1,url.length);
			}
		}
		return url;
	}

	function WM_stop(clipName, doc)	
	{
		if (WM_stop.arguments.length < 2)
		{
			doc = document;
		}		

		var clipRef = WM_checkClipRef(clipName,"WM_stop",doc);		

		if (clipRef == null)
		{
			if (WM_debug)
				alert("In call to WM_stop():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return;
		}
		else if (WM_getPlayState(clipRef) == WM_STOPPED)
		{
			return;
		}
		else
		{
			clipRef.Stop();
			clipRef.CurrentPosition = 0;
		}
	}	

	function WM_play(clipName, doc)
	{
		if (WM_play.arguments.length < 2)
		{
			doc = document;
		}		

		var clipRef = WM_checkClipRef(clipName,"WM_play",doc);		

		if (clipRef == null)
		{
			if (WM_debug)
				alert("In call to WM_play():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return;
		}
		else
		{
			WM_requestPlay(clipRef);
			//clipRef.Play();
		}
	}

	function WM_pause(clipName, doc)
	{	
		if (WM_pause.arguments.length < 2)
		{
			doc = document;
		}		

		var clipRef = WM_checkClipRef(clipName,"WM_pause",doc);		

		if (clipRef == null)
		{
			if (WM_debug)
				alert("In call to WM_pause():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return;
		}
		else
		{
			clipRef.Pause();
		}
	}
	
	function WM_getVolume(clipName, doc)	
	{
		if (WM_getVolume.arguments.length < 2)
		{
			doc = document;
		}		

		var clipRef = WM_checkClipRef(clipName,"WM_getVolume",doc);		

		if (clipRef == null)
		{
			if (WM_debug)
				alert("In call to WM_getVolume():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return 0;
		}
		else
		{
			return Math.round((clipRef.Volume+10000)/100);
		}
	}

	function WM_setVolume(clipName, vol, doc)	
	{
		if (WM_setVolume.arguments.length < 3)
		{
			doc = document;
		}		

		var clipRef = WM_checkClipRef(clipName,"WM_setVolume",doc);		

		if (clipRef == null)
		{
			if (WM_debug)
				alert("In call to WM_setVolume():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
			return;
		}
		else
		{
			return clipRef.Volume = (vol*100-10000);
		}
	}


